package edu.uky.ai.csp;

import edu.uky.ai.csp.kr.Problem;
import edu.uky.ai.csp.kr.Solution;

/**
 * Solves a given constraint satisfaction problem and prints out information
 * about how much work was done to reach the solution.
 * 
 * @author Stephen G. Ware
 */
public class Main {

	/** Set the problem to be solved (see {@link Problems}) */
	private static final Problem PROBLEM = Problems.EASY_SUDOKU;
	
	/**
	 * Solves the problem, printing out information along the way.
	 * 
	 * @param args ignored
	 */
	public static void main(String[] args) {
		Solution root = new Solution(PROBLEM);
		System.out.println("INITIAL STATE\n\n" + root);
		Solver.propagate(root);
		System.out.println("\nSIMPLIFIED INITIAL STATE\n\n" + root);
		Solution solution = Solver.solve(root);
		System.out.println("\nSOLUTION\n");
		if(solution == null)
			System.out.println("none");
		else
			System.out.println(solution);
		System.out.println("\nSTATES GENERATED: " + root.countDescendants());
	}
}
